﻿<%@ Import Namespace="Soneta.Magazyny" %>
<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>

<%@ Page Language="c#" AutoEventWireup="false" CodePage="1200" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>Przyjęcia zewnętrzne niefakturowane</title>
    <meta content="C#" name="CODE_LANGUAGE" />
    <meta content="JavaScript" name="vs_defaultClientScript" />
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
</head>

<script runat="server">


    public class ParametryWydruku : ContextBase
    {
        public ParametryWydruku(Context context) : base(context)
        {
            DrukujPozycje = true;
        }

        public bool DrukujPozycje { get; set; }
    }

    [Context]
    public ParametryWydruku Paremetry { get; set; }

    HandelModule hm;
    

    public Soneta.Handel.Forms.DokHandloweViewInfo.WParams pars;

    void dc_ContextLoad(object sender, EventArgs args) {
        const string cat = @"Kategoria";

        dc.Context.Set(Soneta.Types.Date.Today);
        hm = HandelModule.GetInstance(dc.Session);

        SubTable st;

        Magazyn magazyn = (Magazyn)dc[typeof(Magazyn)];
        if (magazyn == null)
            st = hm.DokHandlowe.WgDaty;
        else
            st = hm.DokHandlowe.WgMagazyn[magazyn];

        pars = (Soneta.Handel.Forms.DokHandloweViewInfo.WParams)
            dc[typeof(Soneta.Handel.Forms.DokHandloweViewInfo.WParams)];

        RowCondition cond = new FieldCondition.Contain("Data", pars.Okres);
        cond &=
            new FieldCondition.Equal(cat, KategoriaHandlowa.PrzyjęcieMagazynowe) |
            new FieldCondition.Equal(cat, KategoriaHandlowa.KorektaPrzyjęciaMagazynowego);
        cond &= new FieldCondition.Equal("Definicja.DuplikatWartosci", false);
        cond &= new FieldCondition.Equal("Definicja.Wewnetrzny", false);
        cond &= new FieldCondition.NotEqual("Stan", StanDokumentuHandlowego.Anulowany);
        cond &= new FieldCondition.NotEqual("Stan", StanDokumentuHandlowego.Bufor);
        cond &= new FieldCondition.Equal("Definicja.KierunekMagazynu", KierunekPartii.Przychód);

        SubTable stG = st[cond];
        stG.ForceAllRows();

        if (Paremetry.DrukujPozycje)
        {
            Grid1.DataSource = stG;
            Grid2.Visible = false;
        }
        else
        {
            Grid2.DataSource = ZbierzDokumenty(stG);
            Grid1.Visible = false;
        }
    }

    private IEnumerable ZbierzDokumenty(SubTable stG)
    {
        var dokInfos = new ArrayList();
        int lp1 = 0;
        foreach (DokumentHandlowy dh in stG)
        {
            if(dh.DokumentKorygujący != null)
               continue;

            bool saRozliczone = false;
            bool saNieRozliczone = false;

            foreach (PozycjaDokHandlowego pdh in dh.Pozycje)
            {
                bool poza_okresem;
                if (JestMagazynowa(pdh, out poza_okresem))
                {
                    sumujZmianeNetto(pdh);
                    saNieRozliczone = true;
                } else {
                    saRozliczone = true;
                }
            }

            if (saNieRozliczone)
            {
                var czescioweinfo = "";
                if(saRozliczone)
                    czescioweinfo = " (rozliczony częściowo)";

                string info = string.Format("{0}, Kontrahent: {1}, Data: {2}, Suma netto: {3}{4}", dh.Numer.Pelny, dh.Kontrahent, dh.Data, dh.SumaPoKorekcie.Netto, czescioweinfo);
                dokInfos.Add(new Total(++lp1, info, 0));
            }
        }

        BindGridTotal();
        return dokInfos;
    }

    protected void Grid1_ItemsGet(object sender, ItemsGetEventArgs args) {
        if (args.Deep != 1) return;

        DokumentHandlowy row = args.Row as DokumentHandlowy;
        if (row != null)
            args.Enumerable = row.Pozycje;
    }

    int lp;
    decimal sumaTowarów;
    decimal sumaUsług;

    private void sumujZmianeNetto(PozycjaDokHandlowego poz)
    {
       if (poz.Towar != null && (poz.Towar.Typ == Soneta.Towary.TypTowaru.Towar || poz.Towar.Typ == Soneta.Towary.TypTowaru.Produkt))
            sumaTowarów += poz.NettoCy.Value;
        if (poz.Towar != null && (poz.Towar.Typ == Soneta.Towary.TypTowaru.Usługa))
            sumaUsług += poz.NettoCy.Value;
    }

    private DokumentHandlowy magPrev = null;

    void Grid1_BeforeRow(Object sender, RowEventArgs args) {

         var poz = (PozycjaDokHandlowego)args.Row;
        DokumentHandlowy mag = poz.Dokument;

        
        bool poza_okresem;
        bool han_lub_nad = HandlowaLubNadrzędna(poz, pars.Okres, out poza_okresem);
        if (poza_okresem) ColPozaOkresem.EditValue = "TAK";


        bool han_lub_pod = HandlowaLubPodrzędna(poz, pars.Okres, out poza_okresem);
        if (poza_okresem) ColPozaOkresem.EditValue = "TAK";
        
        args.VisibleRow = !mag.Definicja.Wewnetrzny && !han_lub_nad && !han_lub_pod && mag.DokumentKorygujący == null;

        if (!args.VisibleRow) return;

        if(poz.Towar != null && (poz.Towar.Typ == Soneta.Towary.TypTowaru.Towar || poz.Towar.Typ == Soneta.Towary.TypTowaru.Produkt))
            sumaTowarów += poz.NettoCy.Value;

        if (poz.Towar != null && poz.Towar.Typ == Soneta.Towary.TypTowaru.Usługa)
            sumaUsług += poz.NettoCy.Value;
        
        //TID: 24407; Błąd: Nagłowki wyświetlają się dla każdej pozycji <-- z racji zmieniającego się Lp. uzytego w GroupLine
        if(mag != magPrev)            
            lp++;
        magPrev = mag;
        
        Grid1.GroupLine = string.Format("{0}. {1}, Kontrahent: {2}, Data: {3}, Suma netto: {4}", lp, mag.Numer.Pelny, mag.Kontrahent, mag.Data, mag.Suma.Netto);
 
    }

    private static bool JestHandlowy(DokumentHandlowy dok) {
        return KategoriaHandlowa.HandelPierwszy <= dok.Kategoria && dok.Kategoria <= KategoriaHandlowa.HandelOstatni;
    }
    
    public class Total {
        readonly int _lp;
        readonly string _key;
        readonly decimal _value;
        public Total(int lp, string key, decimal value) {
            _lp = lp;
            _key = key;
            _value = value;
        }
        public int Lp { get { return _lp; } }
        public string Key { get { return _key; } }
        public decimal Value { get { return _value; } }
    }

    void Grid1_AfterRender(Object sender, EventArgs args)
    {
        BindGridTotal();
    }

    private void BindGridTotal()
    {
        var arr = new ArrayList();
        arr.Add(new Total(1, @"Suma towarów", sumaTowarów));
        arr.Add(new Total(2, @"Suma usług", sumaUsług));
        arr.Add(new Total(3, @"RAZEM", sumaTowarów+sumaUsług));
        GridTotal.DataSource = arr;
    }

        #region Zmiany 
    
    private bool HandlowaLubNadrzędna(PozycjaDokHandlowego pozycja, FromTo o, out bool poza_okresem) {


        if (JestHandlowy(pozycja.Dokument))
            return !(poza_okresem=!o.Contains(pozycja.Dokument.Data));

        foreach (PozycjaRelacjiHandlowej rel in pozycja.NadrzędneRelacje) {
            if (rel.Relacja.Typ == TypRelacjiHandlowej.HandlowoMagazynowa ||
                 rel.Relacja.Typ == TypRelacjiHandlowej.Korekta)
                return HandlowaLubNadrzędna(rel.Nadrzedna, o, out poza_okresem);
        }

        return (poza_okresem=false);
    }

    private bool HandlowaLubPodrzędna(PozycjaDokHandlowego pozycja, FromTo o, out bool poza_okresem) {

        if (JestHandlowy(pozycja.Dokument))
            return !(poza_okresem=!o.Contains(pozycja.Dokument.Data));

        foreach (PozycjaRelacjiHandlowej rel in pozycja.PodrzędneRelacje) {
            if (rel.Relacja.Typ == TypRelacjiHandlowej.HandlowoMagazynowa ||
                 rel.Relacja.Typ == TypRelacjiHandlowej.Korekta)
                return HandlowaLubPodrzędna(rel.Podrzedna, o, out poza_okresem);
        }

        return (poza_okresem=false);
    }

    private bool JestMagazynowa(PozycjaDokHandlowego pozycja, out bool poza_okresem)
    {
        bool han_lub_nad = HandlowaLubNadrzędna(pozycja, pars.Okres, out poza_okresem);
        bool han_lub_pod = HandlowaLubPodrzędna(pozycja, pars.Okres, out poza_okresem);
        return !pozycja.Dokument.Definicja.Wewnetrzny && !han_lub_nad && !han_lub_pod;
    }

    #endregion

</script>

<body>
    <form id="Form1" runat="server">
    <p>
        <ea:DataContext ID="dc" runat="server" OnContextLoad="dc_ContextLoad"></ea:DataContext>
        <eb:reportheader id="ReportHeader" title="Przyjęcia zewnętrzne niefakturowane|</STRONG>Okres:<STRONG> {2}|</STRONG>Magazyn:<STRONG> {3}</STRONG>|<span style='font-size: 7pt;'>Data wydruku: {4}</span>"
            datamember4="Date" runat="server" datamember3="DokHandloweViewInfo+WParams.Magazyn"
            datamember2="DokHandloweViewInfo+WParams.Okres"></eb:reportheader>
        <ea:Section runat="server" ID="sPrzyjeciaNiefakturowane">
            <font face="Verdana" size="2">Raport pomija przyjęcia w buforze.</font>
            <br />
            <ea:Grid ID="Grid1" runat="server" OnBeforeRow="Grid1_BeforeRow" RowTypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel"
                OnAfterRender="Grid1_AfterRender" onitemsget="Grid1_ItemsGet">
                <Columns>
                    <ea:GridColumn ID="GridColumn5" runat="server" Width="4" Align="Right" DataMember="#"
                        Caption="Lp." EncodeHTML="True">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" DataMember="Towar" Caption="Towar"
                        EncodeHTML="True">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" DataMember="Ilosc" Width="10" Caption="Ilość" Total="Sum" Align="Right"
                        EncodeHTML="True">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" DataMember="NettoCy" Width="10" Align="Right" Total="Sum" Caption="Wartość"
                        Format="{0:n}" ID="ColWartoscNetto" EncodeHTML="True">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Width="12" Align="Right" Caption="Fakturowane poza okresem"
                        ID="ColPozaOkresem" EncodeHTML="True">
                    </ea:GridColumn>
                </Columns>
            </ea:Grid>
            
            <ea:Grid ID="Grid2" runat="server">
                <Columns>
                    <ea:GridColumn ID="gc_21" runat="server" Width="4" Align="Right" DataMember="#" Caption="Lp." EncodeHTML="True"> </ea:GridColumn>
                    <ea:GridColumn ID="gc_22"runat="server" DataMember="Key" Caption="Dokument" EncodeHTML="True"> </ea:GridColumn>
                </Columns>
            </ea:Grid>

        </ea:Section>
        <br />
        <font face="Verdana" size="2">Podsumowanie</font>
        <ea:Grid ID="GridTotal" runat="server">
            <Columns>
                <ea:GridColumn runat="server" Width="4" Align="Right" DataMember="Lp" Caption="Lp." EncodeHTML="True"> </ea:GridColumn>
                <ea:GridColumn runat="server" Width="50" DataMember="Key" Caption="Tabela" EncodeHTML="True"> </ea:GridColumn>
                <ea:GridColumn runat="server" Width="25" DataMember="Value" Caption="Wartość zakupu netto" EncodeHTML="True" Align="Right"> </ea:GridColumn>
            </Columns>
        </ea:Grid>
        <br />
        <eb:reportfooter id="ReportFooter" runat="server" theend="False"></eb:reportfooter>
    </p>
    </form>
</body>
</html>

